/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.service;

import filenet.vw.api.VWSystemAdministration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.service.VWDBExecutePropertyPanel;
import filenet.vw.toolkit.admin.property.service.VWDBExecuteTableCellRenderer;
import filenet.vw.toolkit.admin.property.service.VWDBExecuteTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWSplitPane;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VWDBExecutePanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private VWSystemAdministration m_sysAdmin = null;
    private boolean m_bIsModified = false;
    private JDialog m_parentDialog = null;
    private VWToolbarBorder m_toolBar = null;
    private VWTable m_dbExecuteTable = null;
    private VWDBExecuteTableModel m_tableModel = null;
    private VWDBExecutePropertyPanel m_dbExecutePropertyPanel = null;
    private static final double s_defaultHSplitRatio = 0.25;
    private static final double s_defaultHSplitRatio_bidi = 0.7;

    public VWDBExecutePanel(JDialog parentDialog, VWSystemAdministration sysAdmin) {
        this(parentDialog, sysAdmin, null);
    }

    public VWDBExecutePanel(JDialog parentDialog, VWSystemAdministration sysAdmin, VWDBExecutePropertyPanel dbExecutePropertyPanel) {
        this.m_sysAdmin = sysAdmin;
        this.m_parentDialog = parentDialog;
        this.createControls(dbExecutePropertyPanel);
        this.onSelectedDBExecute();
    }

    public void init() {
        this.m_tableModel.init();
        this.setEnabled(true);
        if (this.m_tableModel.getRowCount() > 0) {
            this.m_dbExecuteTable.setRowSelectionInterval(0, 0);
        }
    }

    public void setEnabled(boolean bEnabled) {
        int nButtonState = 2;
        int nButtons = Integer.MAX_VALUE;
        this.m_toolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBar.getClientPanel(), nButtonState, nButtons));
        if (bEnabled) {
            nButtonState = 1;
            nButtons = 16;
            if (this.m_dbExecuteTable.getSelectedRow() != -1) {
                nButtons |= 0x10100040;
            }
            this.m_toolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBar.getClientPanel(), nButtonState, nButtons));
        }
        this.m_dbExecuteTable.setEnabled(bEnabled);
        this.m_dbExecutePropertyPanel.setEnabled(bEnabled && this.m_tableModel.getRowCount() > 0);
    }

    public boolean isModified() {
        this.stopEditing();
        if (this.m_tableModel != null && this.m_tableModel.isModified()) {
            return true;
        }
        if (this.m_dbExecutePropertyPanel != null && this.m_dbExecutePropertyPanel.isModified()) {
            return true;
        }
        return this.m_bIsModified;
    }

    public void resetModifiedFlag() {
        if (this.m_tableModel != null) {
            this.m_tableModel.resetModifiedFlag();
        }
        if (this.m_dbExecutePropertyPanel != null) {
            this.m_dbExecutePropertyPanel.resetModifiedFlag();
        }
        this.m_bIsModified = false;
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow > this.m_dbExecuteTable.getRowCount() - 1) {
                    nRow = this.m_dbExecuteTable.getRowCount() - 1;
                }
                if (nRow == -1) {
                    return;
                }
                if (nRow == this.m_dbExecuteTable.getSelectedRow()) {
                    this.m_dbExecuteTable.clearSelection();
                }
                this.m_dbExecuteTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
            case 0: {
                if (event.getColumn() != 1) break;
                this.onSelectedDBExecute();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (event.getSource().equals(this.m_dbExecuteTable.getSelectionModel())) {
                if (this.m_dbExecutePropertyPanel != null) {
                    this.m_dbExecutePropertyPanel.stopEditing();
                }
                this.onSelectedDBExecute();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            this.stopEditing();
            if (event.getSource() == this.m_toolBar) {
                switch (event.getID()) {
                    case 16: {
                        this.m_tableModel.addNewDBExecute();
                        break;
                    }
                    case 64: {
                        int nRowIndex = this.m_dbExecuteTable.getSelectedRow();
                        if (nRowIndex == -1) {
                            return;
                        }
                        this.m_tableModel.copyDBExAtIndex(nRowIndex);
                        break;
                    }
                    case 0x10000000: {
                        int nRowIndex = this.m_dbExecuteTable.getSelectedRow();
                        if (nRowIndex == -1) {
                            return;
                        }
                        this.m_tableModel.deleteDBExecuteAtIndex(nRowIndex);
                        break;
                    }
                    case 0x100000: {
                        int nRowIndex = this.m_dbExecuteTable.getSelectedRow();
                        if (nRowIndex == -1) {
                            return;
                        }
                        this.m_tableModel.verifyDbExecuteConnectionAtIndex(nRowIndex);
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_parentDialog, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
        }
    }

    public boolean update() {
        boolean bSuccess = true;
        this.m_dbExecuteTable.stopEditing();
        bSuccess = this.m_tableModel.validateDBExecutes();
        if (bSuccess) {
            bSuccess = this.m_tableModel.update();
        }
        return bSuccess;
    }

    protected void cancelModification() {
        try {
            this.m_sysAdmin.fetchDBExecutionConnections();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void stopEditing() {
        if (this.m_dbExecuteTable != null) {
            this.m_dbExecuteTable.stopEditing();
        }
        if (this.m_dbExecutePropertyPanel != null) {
            this.m_dbExecutePropertyPanel.stopEditing();
        }
    }

    protected void releaseResources() {
        if (this.m_toolBar != null) {
            this.m_toolBar.releaseResources();
            this.m_toolBar = null;
        }
        if (this.m_dbExecuteTable != null) {
            this.m_dbExecuteTable.removeAll();
            this.m_dbExecuteTable = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        if (this.m_dbExecutePropertyPanel != null) {
            this.m_dbExecutePropertyPanel.releaseResources();
            this.m_dbExecutePropertyPanel = null;
        }
        this.m_sysAdmin = null;
        this.removeAll();
    }

    private void createControls(VWDBExecutePropertyPanel dbExecutePropertyPanel) {
        try {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            JPanel leftPanel = this.createTablePanel();
            this.m_dbExecutePropertyPanel = dbExecutePropertyPanel != null ? dbExecutePropertyPanel : new VWDBExecutePropertyPanel(this.m_parentDialog, this.m_dbExecuteTable, this.m_tableModel);
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            VWSplitPane splitPane = null;
            if (compOrientation.isLeftToRight()) {
                splitPane = new VWSplitPane(1, leftPanel, this.m_dbExecutePropertyPanel);
                splitPane.setDividerLocation(0.25);
            } else {
                splitPane = new VWSplitPane(1, this.m_dbExecutePropertyPanel, leftPanel);
                splitPane.setDividerLocation(0.7);
            }
            this.add((Component)splitPane, "Center");
            Color bgColor = this.getBackground();
            JTextArea noteTextArea = new JTextArea();
            noteTextArea.setBackground(bgColor);
            noteTextArea.setEditable(false);
            noteTextArea.setLineWrap(true);
            noteTextArea.setWrapStyleWord(true);
            noteTextArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.add((Component)noteTextArea, "Last");
            this.applyComponentOrientation(this.m_parentDialog.getComponentOrientation());
            noteTextArea.append(VWResource.NoteSystemWideConfigDBExecute);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createTablePanel() {
        try {
            JPanel dbExTablePanel = new JPanel(new BorderLayout());
            dbExTablePanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.m_toolBar = new VWToolbarBorder(VWResource.Name, 0x10100050, VWResource.DBExecuteDescription);
            this.m_toolBar.setToolbarBackground(this.getBackground());
            this.m_toolBar.addToolbarBorderActionNotifier(this);
            VWAccessibilityHelper.setAccessibility(this.m_toolBar, this, VWResource.DBExecuteConnections, VWResource.DBExecute);
            JPanel childPanel = this.m_toolBar.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_tableModel = new VWDBExecuteTableModel(this.m_parentDialog, this.m_sysAdmin);
            this.m_tableModel.addTableModelListener(this);
            this.m_dbExecuteTable = new VWTable(this.m_tableModel);
            this.m_dbExecuteTable.setRowSelectionAllowed(true);
            this.m_dbExecuteTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_dbExecuteTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            ListSelectionModel lm = this.m_dbExecuteTable.getSelectionModel();
            lm.setSelectionMode(0);
            lm.addListSelectionListener(this);
            this.m_dbExecuteTable.setShowGrid(false);
            this.m_dbExecuteTable.setTableHeader(null);
            this.m_dbExecuteTable.setRowHeight(26);
            TableColumnModel columnModel = this.m_dbExecuteTable.getColumnModel();
            TableColumn aColumn = columnModel.getColumn(0);
            aColumn.setCellRenderer(new VWDBExecuteTableCellRenderer());
            aColumn.setMinWidth(20);
            aColumn.setMaxWidth(20);
            VWAccessibilityHelper.setAccessibility(this.m_dbExecuteTable, this, VWResource.DBExecuteTable, VWResource.DBExecuteTable);
            VWAccessibilityHelper.setLabelFor(new JLabel(VWResource.DBExecute), this.m_dbExecuteTable);
            childPanel.add((Component)new JScrollPane(this.m_dbExecuteTable), "Center");
            dbExTablePanel.add((Component)this.m_toolBar, "Center");
            return dbExTablePanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void onSelectedDBExecute() {
        try {
            int nRowIndex = this.m_dbExecuteTable.getSelectedRow();
            int nButtons = 0x10100040;
            if (nRowIndex == -1) {
                this.m_toolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBar.getClientPanel(), 2, nButtons));
            } else {
                this.m_toolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBar.getClientPanel(), 1, nButtons));
            }
            if (this.m_dbExecutePropertyPanel != null) {
                if (this.m_dbExecutePropertyPanel.isModified()) {
                    this.m_bIsModified = true;
                }
                this.m_dbExecutePropertyPanel.setDBExecute(this.m_tableModel.getRowItemAt(nRowIndex));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

